#pragma once

#include "ntp_sync.h"

#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <memory>

namespace quasar {

    class NtpEndpoint {
    public:
        NtpEndpoint(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IUserConfigProvider> userConfigProvider);
        ~NtpEndpoint();

        static const std::string SERVICE_NAME;

    private:
        Lifetime lifetime_;
        std::shared_ptr<ipc::IServer> server_;

        std::atomic<bool> hasNtpSync_{false};
        std::atomic<bool> isNtpSyncSuccessful_{false};
        std::unique_ptr<NtpSync> ntpSync_;
    };

} // namespace quasar
