#include "ntp_service.h"

#include <yandex_io/libs/telemetry/telemetry.h>

#include <memory>

using namespace quasar;

NtpService::NtpService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IUserConfigProvider> userConfigProvider)
{
    ntpStarter_ =
        [this, device, ipcFactory, userConfigProvider] {
            ntpEndpoint_ = std::make_unique<NtpEndpoint>(device, ipcFactory, userConfigProvider);
        };
}

std::string NtpService::getServiceName() const {
    return NtpEndpoint::SERVICE_NAME;
}

void NtpService::start() {
    ntpStarter_();
}

void NtpService::stop()
{
    ntpEndpoint_.reset();
}
