#pragma once

#include "ntp_endpoint.h"

#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <memory>

namespace quasar {
    class NtpService: public QuasarService {
    public:
        NtpService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IUserConfigProvider> userConfigProvider);

        std::string getServiceName() const override;
        void start() override;
        void stop() override;

    private:
        std::function<void()> ntpStarter_;
        std::unique_ptr<NtpEndpoint> ntpEndpoint_;
    };
} // namespace quasar
