#include "push_service.h"

#include <yandex_io/libs/telemetry/telemetry.h>

#include <memory>

using namespace quasar;

PushService::PushService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IAuthProvider> authProvider,
    std::shared_ptr<IUserConfigProvider> userConfigProvider)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , authProvider_(std::move(authProvider))
    , userConfigProvider_(std::move(userConfigProvider))
{
}

std::string PushService::getServiceName() const {
    return PushEndpoint::SERVICE_NAME;
}

void PushService::start() {
    pushEndpointPtr_ = std::make_unique<PushEndpoint>(device_, ipcFactory_, authProvider_, userConfigProvider_);
}
