#pragma once

#include "push_endpoint.h"

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {
    class PushService: public QuasarService {
    public:
        PushService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IAuthProvider> authProvider,
            std::shared_ptr<IUserConfigProvider> userConfigProvider);
        std::string getServiceName() const override;

    private:
        void start() override;

        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        const std::shared_ptr<IAuthProvider> authProvider_;
        const std::shared_ptr<IUserConfigProvider> userConfigProvider_;

        std::unique_ptr<PushEndpoint> pushEndpointPtr_;
    };
} // namespace quasar
