#include "xiva_operations.h"

using namespace quasar;
/* static members allocation */
const std::unordered_set<std::string> XivaOperations::DECLARED_XIVA_OPERATIONS = {
    SERVER_ACTION,
    REMINDER,
    TEXT_ACTION,
    SEND_BUGREPORT,
    SWITCH_USER,
    UPDATE_CONFIG,
    UPDATE_DEVICE_STATE,
    PUSH,
    PING,
    WEB,
    BOTTOM_SHEET,
};

bool XivaOperations::isDeclaredXivaOperation(const std::string& operation)
{
    return DECLARED_XIVA_OPERATIONS.count(operation) != 0;
}
