#pragma once

#include <yandex_io/libs/base/utils.h>

#include <string>
#include <unordered_set>

namespace quasar {

    class XivaOperations final {
    public:
        /**
         * @brief Check that Xiva Operation is known by Quasar Software
         * @param operation - operation to check
         * @return true - operation is known by Quasar, false - not valid (need to check that this operation is not new)
         */
        static bool isDeclaredXivaOperation(const std::string& operation);

        static constexpr const char* SERVER_ACTION = "server_action";
        static constexpr const char* REMINDER = "reminder";
        static constexpr const char* TEXT_ACTION = "text_action";
        static constexpr const char* SEND_BUGREPORT = "send_bugreport";
        static constexpr const char* SWITCH_USER = "switch_user";
        static constexpr const char* UPDATE_CONFIG = "update_config";
        static constexpr const char* UPDATE_DEVICE_STATE = "update_device_state";
        static constexpr const char* PUSH = "push";
        static constexpr const char* PING = "ping";
        static constexpr const char* WEB = "web";
        static constexpr const char* BOTTOM_SHEET = "bottom_sheet";

    private:
        static const std::unordered_set<std::string> DECLARED_XIVA_OPERATIONS;
    };

} /* namespace quasar */
