#include "secret_commands.h"

using namespace quasar;

SecretCommands::SecretCommands(const Json::Value& config)
{
    if (config.isMember("secretMsgList")) {
        const auto& secretMsgListJson = config["secretMsgList"];

        for (const auto& secretMsgJson : secretMsgListJson) {
            const auto& hash = secretMsgJson["hash"].asString();
            const auto& cmd = secretMsgJson["cmd"].asString();

            map_[hash] = {cmd, tryGetBool(secretMsgJson, "runtime", false)};
        }
    }
}

std::optional<SecretCommands::Command> SecretCommands::getCommand(const std::string& hash) const {
    if (auto it = map_.find(hash); it != map_.end()) {
        return it->second;
    }
    return {};
}
