#pragma once

#include <yandex_io/libs/json_utils/json_utils.h>

#include <map>
#include <string>

namespace quasar {
    class SecretCommands final {
    public:
        struct Command {
            std::string command;
            bool isRuntime;
        };

    public:
        explicit SecretCommands(const Json::Value& config);

        std::optional<Command> getCommand(const std::string& hash) const;

    private:
        std::map<std::string, Command> map_;
    };
} // namespace quasar
