#pragma once

#include "secret_commands.h"

#include <yandex_io/capabilities/file_player/interfaces/i_file_player_capability.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/setup_parser/credentials.h>
#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/private/device_context.h>
#include <yandex_io/libs/telemetry/named_latency.h>

#include <mutex>

namespace quasar {
    class SetupEndpoint {
    public:
        static const std::string SERVICE_NAME;

        explicit SetupEndpoint(std::shared_ptr<YandexIO::IDevice> device,
                               std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                               std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability);
        ~SetupEndpoint();

        bool connectWithCredentials(SetupParser::Credentials credentials, quasar::proto::SetupSource source);

    private:
        using byte = unsigned char;

        static constexpr long MIN_ERROR_TIMEOUT_MS = 20000;
        static constexpr int RETRIES_COUNT = 5;

        std::shared_ptr<YandexIO::IDevice> device_;
        YandexIO::NamedLatency latencyReporter_;
        std::unique_ptr<YandexIO::DeviceCryptography> deviceCryptography_;
        const std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability_;
        std::shared_ptr<ipc::IServer> server_;
        std::shared_ptr<ipc::IConnector> wifiConnector_;
        std::shared_ptr<ipc::IConnector> bleInitdConnector_;
        std::shared_ptr<ipc::IConnector> updaterConnector_;
        YandexIO::DeviceContext deviceContext_;
        SecretCommands secretCommands_;
        quasar::proto::UpdateState_State updateState_;

        void handleQuasarMessage(const ipc::SharedMessage& message);

        void onDataReceived(const std::vector<byte>& bytes, quasar::proto::SetupSource source);
        bool decryptCredentials(const proto::EncryptedSetupCredentialsMessage& msg,
                                quasar::proto::SetupSource source, std::vector<byte>& result);
        SetupParser::Credentials parseInitData(const std::vector<byte>& bytes, quasar::proto::SetupSource source);
        bool requestConnect(const SetupParser::Credentials& credentials);

        bool handleExplicitWifiType(const SetupParser::Credentials& credentials, quasar::proto::SetupSource source);
        bool handleUnknownWifiType(SetupParser::Credentials& credentials, quasar::proto::SetupSource source);

        static std::string getEventName(quasar::proto::SetupSource setupSource, const std::string& name);
        static Json::Value getEventBody(const SetupParser::Credentials& credentials);

        static std::string getSoundName(quasar::proto::SetupStatusMessage::SetupStatus status);
        void scheduleError(quasar::proto::SetupStatusMessage::SetupStatus status, long timeoutMs, const SetupParser::Credentials& credentials);
        void notifySetupStatusViaBle(quasar::proto::SetupStatusMessage::SetupStatus status);
    };

} // namespace quasar
