#include "setup_service.h"

using namespace quasar;

SetupService::SetupService(std::shared_ptr<YandexIO::IDevice> device,
                           std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                           std::shared_ptr<YandexIO::SDKInterface> sdk)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , sdk_(std::move(sdk))
{
}

std::string SetupService::getServiceName() const {
    return SetupEndpoint::SERVICE_NAME;
}

void SetupService::start() {
    setupEndpointPtr_ = std::make_unique<SetupEndpoint>(device_, ipcFactory_, sdk_->getFilePlayerCapability());
}
