#pragma once

#include "setup_endpoint.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/sdk/sdk_interface.h>

namespace quasar {
    class SetupService: public QuasarService {
    public:
        SetupService(std::shared_ptr<YandexIO::IDevice> device,
                     std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                     std::shared_ptr<YandexIO::SDKInterface> sdk);

        std::string getServiceName() const override;

    private:
        void start() override;

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<YandexIO::SDKInterface> sdk_;
        std::unique_ptr<SetupEndpoint> setupEndpointPtr_;
    };
} // namespace quasar
