#include "stereo_pair_service.h"

#include <yandex_io/libs/logging/logging.h>

YIO_DEFINE_LOG_MODULE("stereo_pair");

using namespace quasar;

StereoPairService::StereoPairService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IClockTowerProvider> clockTowerProvider,
    std::shared_ptr<IGlagolClusterProvider> glagolCluster,
    std::shared_ptr<ISpectrogramAnimationProvider> spectrogramAnimationProvider,
    std::shared_ptr<IUserConfigProvider> userConfigProvider,
    std::shared_ptr<IVolumeManagerProvider> volumeManagerProvider,
    std::shared_ptr<YandexIO::SDKInterface> sdk)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , clockTowerProvider_(std::move(clockTowerProvider))
    , glagolCluster_(std::move(glagolCluster))
    , spectrogramAnimationProvider_(std::move(spectrogramAnimationProvider))
    , userConfigProvider_(std::move(userConfigProvider))
    , volumeManagerProvider_(std::move(volumeManagerProvider))
    , sdk_(std::move(sdk))
{
}

std::string StereoPairService::getServiceName() const {
    return "stereo_pair";
}

void StereoPairService::start()
{
    stereoPairEndpoint_ = std::make_unique<StereoPairEndpoint>(
        device_,
        ipcFactory_,
        clockTowerProvider_,
        glagolCluster_,
        spectrogramAnimationProvider_,
        userConfigProvider_,
        volumeManagerProvider_,
        sdk_);
}
