#pragma once

#include "stereo_pair_endpoint.h"

#include <yandex_io/interfaces/clock_tower/i_clock_tower_provider.h>
#include <yandex_io/interfaces/glagol/i_glagol_cluster_provider.h>
#include <yandex_io/interfaces/spectrogram_animation/i_spectrogram_animation_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/interfaces/volume_manager/i_volume_manager_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <memory>
#include <string>

namespace quasar {

    class StereoPairService: public QuasarService {
    public:
        StereoPairService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IClockTowerProvider> clockTowerProvider,
            std::shared_ptr<IGlagolClusterProvider> glagolCluster,
            std::shared_ptr<ISpectrogramAnimationProvider> spectrogramAnimationProvider,
            std::shared_ptr<IUserConfigProvider> userConfigProvider,
            std::shared_ptr<IVolumeManagerProvider> volumeManagerProvider,
            std::shared_ptr<YandexIO::SDKInterface> sdk);

        std::string getServiceName() const override;
        void start() override;

    private:
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        const std::shared_ptr<IClockTowerProvider> clockTowerProvider_;
        const std::shared_ptr<IGlagolClusterProvider> glagolCluster_;
        const std::shared_ptr<ISpectrogramAnimationProvider> spectrogramAnimationProvider_;
        const std::shared_ptr<IUserConfigProvider> userConfigProvider_;
        const std::shared_ptr<IVolumeManagerProvider> volumeManagerProvider_;

        std::unique_ptr<StereoPairEndpoint> stereoPairEndpoint_;
        std::shared_ptr<YandexIO::SDKInterface> sdk_;
    };

} // namespace quasar
