#include "sync_service.h"

#include <yandex_io/libs/telemetry/telemetry.h>

#include <memory>

using namespace quasar;

SyncService::SyncService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IAuthProvider> authProvider,
    std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
    std::shared_ptr<IBackoffRetries> delayTimingsPolicy)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , authProvider_(std::move(authProvider))
    , deviceStateProvider_(std::move(deviceStateProvider))
    , delayTimingsPolicy_(std::move(delayTimingsPolicy))
{
}

std::string SyncService::getServiceName() const {
    return SyncEndpoint::SERVICE_NAME;
}

void SyncService::start() {
    endpointPtr_ = std::make_unique<SyncEndpoint>(device_, ipcFactory_, authProvider_, deviceStateProvider_, delayTimingsPolicy_);
}
