#pragma once

#include "sync_endpoint.h"

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {
    class SyncService: public QuasarService {
    public:
        SyncService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IAuthProvider> authProvider,
            std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
            std::shared_ptr<IBackoffRetries> delayTimingsPolicy);

        std::string getServiceName() const override;

    private:
        void start() override;

        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<IAuthProvider> authProvider_;
        std::shared_ptr<IDeviceStateProvider> deviceStateProvider_;
        std::unique_ptr<SyncEndpoint> endpointPtr_;
        std::shared_ptr<IBackoffRetries> delayTimingsPolicy_;
    };
} // namespace quasar
