#pragma once

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/sdk/private/device_context.h>

#include <string>

namespace quasar {

    class TelemetryProxyEndpoint {
    public:
        explicit TelemetryProxyEndpoint(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        ~TelemetryProxyEndpoint();

        static const std::string SERVICE_NAME;

    private:
        void handleNetworkdMessage(const ipc::SharedMessage& message);
        void handleWifidMessage(const ipc::SharedMessage& message);
        void handleSyncdMessage(const ipc::SharedMessage& message);

        void handleLocation(const proto::Location& location);
        void handleTimezone(const proto::Timezone& timezone);

        void sendConfigToMonitor();
        void sendNetworkStatusToMonitor();

    private:
        std::shared_ptr<YandexIO::IDevice> device_;

        mutable std::mutex networkStatusMutex_;
        proto::NetworkStatus networkStatus_;
        std::mutex configMutex_;
        std::string configCache_;

        std::shared_ptr<ipc::IConnector> networkdConnector_;
        std::shared_ptr<ipc::IConnector> wifidConnector_;
        std::shared_ptr<ipc::IConnector> syncdConnector_;
        std::shared_ptr<ipc::IConnector> monitordConnector_;
        std::unique_ptr<YandexIO::DeviceContext> deviceContext_;
    };

} // namespace quasar
