#include "telemetry_proxy_service.h"

using namespace quasar;

TelemetryProxyService::TelemetryProxyService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
{
}

std::string TelemetryProxyService::getServiceName() const {
    return TelemetryProxyEndpoint::SERVICE_NAME;
}

void TelemetryProxyService::start() {
    endpointPtr_ = std::make_unique<TelemetryProxyEndpoint>(device_, ipcFactory_);
}
