#pragma once

#include "telemetry_proxy_endpoint.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {

    class TelemetryProxyService: public QuasarService {
    public:
        TelemetryProxyService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);

        std::string getServiceName() const override;

    private:
        void start() override;

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<TelemetryProxyEndpoint> endpointPtr_;
    };

} // namespace quasar
