#pragma once

#include <json/json.h>

#include <util/folder/path.h>
#include <string>

namespace quasar {
    class Crc32CheckPolicy {
    public:
        Crc32CheckPolicy(const Json::Value& deviceUpdatesdConfig);
        Crc32CheckPolicy(bool enabled, const std::string& path, uint32_t maxAttempts);
        void applySystemConfig(const Json::Value& systemUpdaterConfig);
        bool checkAfterWriteEnabled();
        void registerFail(const std::string& toVersion);
        void registerSuccess(const std::string& toVersion);
        bool updateIsAllowed(const std::string& toVersion);

    private:
        const bool enabledByDeviceConfig_ = false;
        const TFsPath attemptsCounterPath_;
        const uint32_t maxAttempts_;

        bool enabledBySystemConfig_ = true;
        uint32_t attemptsDone_;
        std::string toVersionPersisted_;
        std::mutex mutex_;

        bool persist(const std::string& toVersion);
        bool checkAfterWriteEnabledUnlocked() const;
    };
} // namespace quasar
