#pragma once

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/logging/logging.h>

#include <openssl/bio.h>
#include <openssl/err.h>
#include <openssl/evp.h>
#include <openssl/pem.h>
#include <openssl/sha.h>

#include <cstdlib>
#include <sstream>
#include <stdexcept>
#include <string>
#include <vector>

#include <sys/stat.h>

namespace quasar {

    class OtaUpdateScript final {
    public:
        enum class Type {
            T_UNKNOWN,
            T_STORE_EXEC,
            T_EXEC,
        };

        OtaUpdateScript(std::shared_ptr<YandexIO::IDevice> device,
                        const std::string& script,
                        const std::string& signature, size_t scriptTimestamp,
                        size_t quasarTimestamp, Type type);

        ~OtaUpdateScript();

        OtaUpdateScript(const OtaUpdateScript&) = delete;
        OtaUpdateScript& operator=(const OtaUpdateScript&) = delete;

        bool verify() const;
        bool execute() const;

    private:
        static constexpr const char* SCRIPT_STORE_PATH = "./update_script.sh";

        bool checkSignature() const;
        bool checkTimestamp() const;

        bool storeExec() const;
        bool exec() const;

    private:
        static RSA* getPublicKey(const std::string& path);
        static bool verify(const std::string& data, const std::string& sign,
                           rsa_st* pubKey);
        static std::string getErrorMessage();

    private:
        std::string script_;
        std::string signature_;

        size_t scriptTimestamp_;
        size_t quasarTimestamp_;

        Type scriptType_;

        std::string scriptWithTimestamp_;

        rsa_st* publicKey_{};
    };

} // namespace quasar
