#pragma once

#include <yandex_io/libs/device/device.h>

#include <util/folder/path.h>

#include <string>

namespace quasar {

    class UpdateApplyStatus {
    public:
        UpdateApplyStatus(std::shared_ptr<YandexIO::IDevice> device);
        UpdateApplyStatus(const UpdateApplyStatus&) = delete;

        UpdateApplyStatus& operator=(const UpdateApplyStatus&) = delete;

        ~UpdateApplyStatus();

        static UpdateApplyStatus& getInstance();

        void load();

        void setStarted(const std::string& fromVersion, const std::string& toVersion);

        void setFinished(const std::string& curVersion);

        bool success() const;

        bool wasAttempt() const;

        void deleteFromDisk();

        void saveToDisk();

        std::string getToVersion() const;

        std::string getFromVersion() const;

    private:
        static constexpr const char* DEFAULT_UPDATE_INFO_PATH = "/data/quasar/data/update-info.json";

        TFsPath path_;
        std::string toVersion_;
        std::string fromVersion_;
        uint64_t startTime_;
        bool success_;
        bool wasAttempt_;
        bool shouldSave_;
    };
} // namespace quasar
