#include "update_download_status.h"

using namespace quasar;

void UpdateDownloadStatus::addPeriod(const std::string& version, const std::chrono::steady_clock::time_point start,
                                     const std::chrono::steady_clock::time_point end) {
    if (version != toVersion_) {
        durationInMs_ = 0;
        toVersion_ = version;
    }
    const long duration = std::chrono::duration_cast<std::chrono::milliseconds>(end - start).count();
    durationInMs_ += duration;
}

long UpdateDownloadStatus::getDurationInMs() const {
    return durationInMs_;
}
