#include "test_mediad_utils.h"

#include <yandex_io/libs/json_utils/json_utils.h>

#include <cstring>

using namespace quasar::TestUtils;

std::string quasar::TestUtils::prepareSyncAddition(const std::string& requestId, int index) {
    return "{\"reqId\":\"" + requestId + "\",\"data\":{\"remove\":[0,0],\"add\":[{\"id\":\"37193494\",\"realId\":\"37193494\",\"title\":\"End Of The Line\",\"major\":{\"id\":1,\"name\":\"UNIVERSAL_MUSIC\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":165510,\"storageDir\":\"372712_cb56ca4c.55716772.1.37193494\",\"fileSize\":3972910,\"normalization\":{\"gain\":-7.96,\"peak\":32766},\"artists\":[{\"id\":380998,\"name\":\"Charles PAsi\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"1fd982fe.a.4706023-1\",\"uri\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\"},\"genres\":[]}],\"albums\":[{\"id\":4706023,\"title\":\"Bricks\",\"year\":2017,\"releaseDate\":\"2017-09-29T00:00:00+03:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\",\"genre\":\"conjazz\",\"buy\":[],\"trackCount\":11,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":380998,\"name\":\"Charles PAsi\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"1fd982fe.a.4706023-1\",\"uri\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\"},\"genres\":[]}],\"labels\":[{\"id\":720603,\"name\":\"Decca Records France\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[37193493,35863114,37093754],\"trackPosition\":{\"volume\":1,\"index\":10}}],\"coverUri\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\",\"lyricsAvailable\":false,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true}},{\"id\":\"6119803\",\"realId\":\"6119803\",\"title\":\"Freedom\",\"major\":{\"id\":1,\"name\":\"UNIVERSAL_MUSIC\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":236700,\"storageDir\":\"788891_689b8472.44718953.5.6119803\",\"fileSize\":5681318,\"normalization\":{\"gain\":-7.75,\"peak\":30989},\"artists\":[{\"id\":6820,\"name\":\"Anthony Hamilton\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"ae0dac86.a.72147-1\",\"uri\":\"avatars.yandex.net/get-music-content/42108/ae0dac86.a.72147-1/%%\"},\"genres\":[]},{\"id\":1145488,\"name\":\"Elayna Boynton\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"7d6b718c.a.4622675-1\",\"uri\":\"avatars.yandex.net/get-music-content/103235/7d6b718c.a.4622675-1/%%\"},\"genres\":[]}],\"albums\":[{\"id\":673204,\"title\":\"?????????????? ????????????????????????????\",\"type\":\"compilation\",\"version\":\"???????????? ???? ????????????\",\"contentWarning\":\"clean\",\"year\":2012,\"releaseDate\":\"2012-12-17T00:00:00+04:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/63210/9f083738.a.673204-2/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/63210/9f083738.a.673204-2/%%\",\"genre\":\"films\",\"buy\":[],\"trackCount\":23,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":171,\"name\":\"??????????????\",\"various\":true,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"63f46c6f.a.5614201-1\",\"uri\":\"avatars.yandex.net/get-music-content/97284/63f46c6f.a.5614201-1/%%\"},\"genres\":[]},{\"id\":86707,\"name\":\"??????????????????\",\"various\":true,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"a6791bb4.a.51813-1\",\"uri\":\"avatars.yandex.net/get-music-content/41288/a6791bb4.a.51813-1/%%\"},\"genres\":[]}],\"labels\":[{\"id\":449694,\"name\":\"Visiona Romantica\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[6119803,6119796,6119809],\"trackPosition\":{\"volume\":1,\"index\":6}}],\"coverUri\":\"avatars.yandex.net/get-music-content/63210/9f083738.a.673204-2/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/63210/9f083738.a.673204-2/%%\",\"lyricsAvailable\":true,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true}},{\"id\":\"755501\",\"realId\":\"755501\",\"title\":\"Memory Loves You\",\"major\":{\"id\":3,\"name\":\"SONY\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":178520,\"storageDir\":\"752407_3d1b65ce.55982284.1.755501\",\"fileSize\":4285126,\"normalization\":{\"gain\":-5.90,\"peak\":32400},\"artists\":[{\"id\":171157,\"name\":\"Sophie Zelmani\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"92d9070e.a.2241926-1\",\"uri\":\"avatars.yandex.net/get-music-content/33216/92d9070e.a.2241926-1/%%\"},\"genres\":[]}],\"albums\":[{\"id\":84004,\"title\":\"Memory Loves You\",\"year\":2007,\"releaseDate\":\"2007-02-05T00:00:00+03:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/28589/2c084b82.a.84004-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/28589/2c084b82.a.84004-1/%%\",\"genre\":\"pop\",\"buy\":[],\"trackCount\":10,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":171157,\"name\":\"Sophie Zelmani\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"92d9070e.a.2241926-1\",\"uri\":\"avatars.yandex.net/get-music-content/33216/92d9070e.a.2241926-1/%%\"},\"genres\":[]}],\"labels\":[{\"id\":777410,\"name\":\"SONY BMG MUSIC ENTERTAINMENT (SWEDEN) AB\"},{\"id\":784695,\"name\":\"SONY BMG MUSIC ENTERTAINMENT (SWEDEN)\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[755501,755509],\"trackPosition\":{\"volume\":1,\"index\":2}}],\"coverUri\":\"avatars.yandex.net/get-music-content/28589/2c084b82.a.84004-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/28589/2c084b82.a.84004-1/%%\",\"lyricsAvailable\":true,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true}},{\"id\":\"28598389\",\"realId\":\"28598389\",\"title\":\"Boomerang\",\"major\":{\"id\":87,\"name\":\"BELIEVE_DIGITAL\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":149570,\"storageDir\":\"52139_abb55582.42668987.2.28598389\",\"fileSize\":3590478,\"normalization\":{\"gain\":-6.06,\"peak\":32766},\"artists\":[{\"id\":4287721,\"name\":\"I52Dj\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"9560cb29.a.3421586-1\",\"uri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\"},\"genres\":[]},{\"id\":4339598,\"name\":\"152Dj\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"9560cb29.a.3421586-1\",\"uri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\"},\"genres\":[]}],\"albums\":[{\"id\":3421586,\"title\":\"Deepsea\",\"year\":2016,\"releaseDate\":\"2016-05-19T00:00:00+03:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\",\"genre\":\"house\",\"buy\":[],\"trackCount\":2,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":4287721,\"name\":\"I52Dj\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"9560cb29.a.3421586-1\",\"uri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\"},\"genres\":[]},{\"id\":4339598,\"name\":\"152Dj\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"9560cb29.a.3421586-1\",\"uri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\"},\"genres\":[]}],\"labels\":[{\"id\":434850,\"name\":\"5howtime\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[],\"trackPosition\":{\"volume\":1,\"index\":2}}],\"coverUri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\",\"lyricsAvailable\":false,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true}},{\"id\":\"38260500\",\"realId\":\"38260500\",\"title\":\"Drive Home\",\"major\":{\"id\":123,\"name\":\"IRICOM\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":176600,\"storageDir\":\"1024274_085fa0a7.57224925.1.38260500\",\"fileSize\":4239360,\"normalization\":{\"gain\":-6.97,\"peak\":32393},\"artists\":[{\"id\":160118,\"name\":\"Irene\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"5ea6c4e2.a.4502881-4\",\"uri\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\"},\"genres\":[]}],\"albums\":[{\"id\":4502881,\"title\":\"Drive Home\",\"type\":\"single\",\"year\":2017,\"releaseDate\":\"2017-06-06T00:00:00+03:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\",\"genre\":\"house\",\"buy\":[],\"trackCount\":2,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":160118,\"name\":\"Irene\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"5ea6c4e2.a.4502881-4\",\"uri\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\"},\"genres\":[]}],\"labels\":[{\"id\":21205,\"name\":\"Effective Records\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[],\"trackPosition\":{\"volume\":1,\"index\":1}}],\"coverUri\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\",\"lyricsAvailable\":true,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true}}],\"index\":" + std::to_string(index) + "},\"result\":{\"success\":true}}";
}

std::string quasar::TestUtils::prepareSyncAdditionWithShots(const std::string& requestId, int index) {
    return "{\"reqId\":\"" + requestId + "\",\"data\":{\"remove\":[0,0],\"add\":[{\"id\":\"37193494\",\"realId\":\"37193494\",\"title\":\"End Of The Line\",\"major\":{\"id\":1,\"name\":\"UNIVERSAL_MUSIC\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":165510,\"storageDir\":\"372712_cb56ca4c.55716772.1.37193494\",\"fileSize\":3972910,\"normalization\":{\"gain\":-7.96,\"peak\":32766},\"artists\":[{\"id\":380998,\"name\":\"Charles PAsi\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"1fd982fe.a.4706023-1\",\"uri\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\"},\"genres\":[]}],\"albums\":[{\"id\":4706023,\"title\":\"Bricks\",\"year\":2017,\"releaseDate\":\"2017-09-29T00:00:00+03:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\",\"genre\":\"conjazz\",\"buy\":[],\"trackCount\":11,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":380998,\"name\":\"Charles PAsi\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"1fd982fe.a.4706023-1\",\"uri\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\"},\"genres\":[]}],\"labels\":[{\"id\":720603,\"name\":\"Decca Records France\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[37193493,35863114,37093754],\"trackPosition\":{\"volume\":1,\"index\":10}}],\"coverUri\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/99892/1fd982fe.a.4706023-1/%%\",\"lyricsAvailable\":false,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true},\"shotInfo\":{\"audio\":\"example.com/test.mp3\",\"id\":\"shot1\",\"durationMs\":5000}},{\"id\":\"6119803\",\"realId\":\"6119803\",\"title\":\"Freedom\",\"major\":{\"id\":1,\"name\":\"UNIVERSAL_MUSIC\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":236700,\"storageDir\":\"788891_689b8472.44718953.5.6119803\",\"fileSize\":5681318,\"normalization\":{\"gain\":-7.75,\"peak\":30989},\"artists\":[{\"id\":6820,\"name\":\"Anthony Hamilton\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"ae0dac86.a.72147-1\",\"uri\":\"avatars.yandex.net/get-music-content/42108/ae0dac86.a.72147-1/%%\"},\"genres\":[]},{\"id\":1145488,\"name\":\"Elayna Boynton\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"7d6b718c.a.4622675-1\",\"uri\":\"avatars.yandex.net/get-music-content/103235/7d6b718c.a.4622675-1/%%\"},\"genres\":[]}],\"albums\":[{\"id\":673204,\"title\":\"?????????????? ????????????????????????????\",\"type\":\"compilation\",\"version\":\"???????????? ???? ????????????\",\"contentWarning\":\"clean\",\"year\":2012,\"releaseDate\":\"2012-12-17T00:00:00+04:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/63210/9f083738.a.673204-2/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/63210/9f083738.a.673204-2/%%\",\"genre\":\"films\",\"buy\":[],\"trackCount\":23,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":171,\"name\":\"??????????????\",\"various\":true,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"63f46c6f.a.5614201-1\",\"uri\":\"avatars.yandex.net/get-music-content/97284/63f46c6f.a.5614201-1/%%\"},\"genres\":[]},{\"id\":86707,\"name\":\"??????????????????\",\"various\":true,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"a6791bb4.a.51813-1\",\"uri\":\"avatars.yandex.net/get-music-content/41288/a6791bb4.a.51813-1/%%\"},\"genres\":[]}],\"labels\":[{\"id\":449694,\"name\":\"Visiona Romantica\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[6119803,6119796,6119809],\"trackPosition\":{\"volume\":1,\"index\":6}}],\"coverUri\":\"avatars.yandex.net/get-music-content/63210/9f083738.a.673204-2/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/63210/9f083738.a.673204-2/%%\",\"lyricsAvailable\":true,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true},\"shotInfo\":{\"audio\":\"example.com/test.mp3\",\"id\":\"shot2\",\"durationMs\":5000}},{\"id\":\"755501\",\"realId\":\"755501\",\"title\":\"Memory Loves You\",\"major\":{\"id\":3,\"name\":\"SONY\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":178520,\"storageDir\":\"752407_3d1b65ce.55982284.1.755501\",\"fileSize\":4285126,\"normalization\":{\"gain\":-5.90,\"peak\":32400},\"artists\":[{\"id\":171157,\"name\":\"Sophie Zelmani\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"92d9070e.a.2241926-1\",\"uri\":\"avatars.yandex.net/get-music-content/33216/92d9070e.a.2241926-1/%%\"},\"genres\":[]}],\"albums\":[{\"id\":84004,\"title\":\"Memory Loves You\",\"year\":2007,\"releaseDate\":\"2007-02-05T00:00:00+03:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/28589/2c084b82.a.84004-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/28589/2c084b82.a.84004-1/%%\",\"genre\":\"pop\",\"buy\":[],\"trackCount\":10,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":171157,\"name\":\"Sophie Zelmani\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"92d9070e.a.2241926-1\",\"uri\":\"avatars.yandex.net/get-music-content/33216/92d9070e.a.2241926-1/%%\"},\"genres\":[]}],\"labels\":[{\"id\":777410,\"name\":\"SONY BMG MUSIC ENTERTAINMENT (SWEDEN) AB\"},{\"id\":784695,\"name\":\"SONY BMG MUSIC ENTERTAINMENT (SWEDEN)\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[755501,755509],\"trackPosition\":{\"volume\":1,\"index\":2}}],\"coverUri\":\"avatars.yandex.net/get-music-content/28589/2c084b82.a.84004-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/28589/2c084b82.a.84004-1/%%\",\"lyricsAvailable\":true,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true},\"shotInfo\":{\"audio\":\"example.com/test.mp3\",\"id\":\"shot3\",\"durationMs\":5000}},{\"id\":\"28598389\",\"realId\":\"28598389\",\"title\":\"Boomerang\",\"major\":{\"id\":87,\"name\":\"BELIEVE_DIGITAL\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":149570,\"storageDir\":\"52139_abb55582.42668987.2.28598389\",\"fileSize\":3590478,\"normalization\":{\"gain\":-6.06,\"peak\":32766},\"artists\":[{\"id\":4287721,\"name\":\"I52Dj\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"9560cb29.a.3421586-1\",\"uri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\"},\"genres\":[]},{\"id\":4339598,\"name\":\"152Dj\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"9560cb29.a.3421586-1\",\"uri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\"},\"genres\":[]}],\"albums\":[{\"id\":3421586,\"title\":\"Deepsea\",\"year\":2016,\"releaseDate\":\"2016-05-19T00:00:00+03:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\",\"genre\":\"house\",\"buy\":[],\"trackCount\":2,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":4287721,\"name\":\"I52Dj\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"9560cb29.a.3421586-1\",\"uri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\"},\"genres\":[]},{\"id\":4339598,\"name\":\"152Dj\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"9560cb29.a.3421586-1\",\"uri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\"},\"genres\":[]}],\"labels\":[{\"id\":434850,\"name\":\"5howtime\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[],\"trackPosition\":{\"volume\":1,\"index\":2}}],\"coverUri\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/38044/9560cb29.a.3421586-1/%%\",\"lyricsAvailable\":false,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true},\"shotInfo\":{\"audio\":\"example.com/test.mp3\",\"id\":\"shot4\",\"durationMs\":5000}},{\"id\":\"38260500\",\"realId\":\"38260500\",\"title\":\"Drive Home\",\"major\":{\"id\":123,\"name\":\"IRICOM\"},\"available\":true,\"availableForPremiumUsers\":true,\"durationMs\":176600,\"storageDir\":\"1024274_085fa0a7.57224925.1.38260500\",\"fileSize\":4239360,\"normalization\":{\"gain\":-6.97,\"peak\":32393},\"artists\":[{\"id\":160118,\"name\":\"Irene\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"5ea6c4e2.a.4502881-4\",\"uri\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\"},\"genres\":[]}],\"albums\":[{\"id\":4502881,\"title\":\"Drive Home\",\"type\":\"single\",\"year\":2017,\"releaseDate\":\"2017-06-06T00:00:00+03:00\",\"coverUri\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\",\"genre\":\"house\",\"buy\":[],\"trackCount\":2,\"recent\":false,\"veryImportant\":false,\"artists\":[{\"id\":160118,\"name\":\"Irene\",\"various\":false,\"composer\":false,\"cover\":{\"type\":\"from-album-cover\",\"prefix\":\"5ea6c4e2.a.4502881-4\",\"uri\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\"},\"genres\":[]}],\"labels\":[{\"id\":21205,\"name\":\"Effective Records\"}],\"available\":true,\"availableForPremiumUsers\":true,\"availableForMobile\":true,\"availablePartially\":false,\"bests\":[],\"trackPosition\":{\"volume\":1,\"index\":1}}],\"coverUri\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\",\"ogImage\":\"avatars.yandex.net/get-music-content/103235/5ea6c4e2.a.4502881-4/%%\",\"lyricsAvailable\":true,\"batchId\":\"sync-1539284338832293\",\"batchInfo\":{\"type\":\"dynamic\",\"rid\":\"c2a55a41e613c69919dc6a75f97d251f\",\"general\":true},\"shotInfo\":{\"audio\":\"example.com/test.mp3\",\"id\":\"shot5\",\"durationMs\":5000}}],\"index\":" + std::to_string(index) + "},\"result\":{\"success\":true}}";
}

std::string quasar::TestUtils::prepareUrl(const std::string& requestId, const std::string& prefix) {
    return "{\"reqId\":\"" + requestId + "\",\"data\":{\"url\":\"https://s38vla.storage.yandex.net/get-mp3/606138714160d0adde446baba4561d25/000577f966dd0eb1/music/6/9/data-0.0:5452538615:6621517?track-id=37193494&from=quasar-websocket&uid=602190738&play=false&prefix=" + prefix + "\"},\"result\":{\"success\":true}}";
}

Json::Value quasar::TestUtils::getMusicPlayOptions(std::string sessionId) {
    Json::Value options;
    options["uid"] = "123";
    options["session_id"] = sessionId;
    options["token"] = "sdfsd";
    options["device_id"] = "123123";

    return options;
}

Json::Value quasar::TestUtils::getNextOptions(bool skip, bool setPause) {
    Json::Value options;
    options["skip"] = skip;
    options["setPause"] = setPause;

    return options;
}

Json::Value quasar::TestUtils::getPrevOptions(bool setPause) {
    Json::Value options;
    options["setPause"] = setPause;

    return options;
}

std::string quasar::TestUtils::getPrefixFromUrl(const std::string& url) {
    auto index = url.find("&prefix=");
    if (index == std::string::npos) {
        return "";
    } else {
        index += strlen("&prefix=");
        auto next_index = url.find('&', index + 1);
        if (next_index == std::string::npos) {
            next_index = url.length();
        }

        return url.substr(index, next_index - index);
    }
}

std::string quasar::TestUtils::prepareYandexMusicSuccessResponse(const std::string& requestId) {
    Json::Value response;
    Json::Value result;
    response["reqId"] = requestId;
    result["success"] = true;
    response["result"] = result;
    return jsonToString(response);
}
