#include <yandex_io/libs/bluetooth/bluez/bluez_ble_impl.h>
#include <yandex_io/libs/bluetooth/gatt/dummy_gatt_characteristic.h>
#include <yandex_io/libs/terminate_waiter/terminate_waiter.h>

namespace {

    constexpr uint8_t deviceTypeId = 1;
    constexpr char deviceColor = 'K';
    constexpr uint16_t manufacturerId = 2309;
    const std::string deviceId = "DEADBEEF";

} // namespace

using namespace quasar;

int main() {
    TerminateWaiter waiter;

    BluezBLEImpl bleImpl;

    bleImpl.setManufacturerData({manufacturerId, {deviceTypeId, deviceColor}});

    bleImpl.addGattService(std::make_shared<IGattService>("configuration", "664578b6-c390-42d8-956e-c1ae8b646436"));

    std::set<gatt_permission::GattPermission> permissions{gatt_permission::GattPermission::READ};
    auto characteristic = std::make_shared<DummyGattCharacteristic>("deviceId",
                                                                    "4276d829-46ce-4ce9-9f30-30dbb9a43724",
                                                                    permissions);
    characteristic->setValue({(uint8_t*)deviceId.data(), (uint8_t*)deviceId.data() + deviceId.size()});
    bleImpl.addGattCharacteristic("configuration", characteristic);

    bleImpl.startAdvertising();

    waiter.wait();

    return 0;
}
