#include <yandex_io/libs/json_utils/json_utils.h>

#include <fstream>
#include <iostream>

using namespace quasar;

void usage(const char* argv0)
{
    std::cerr << "Invalid arguments! \n"
              << "Usage: " << argv0 << " output_file input_file*\n";
}

int main(int argc, char** argv)
{
    if (argc < 3) {
        usage(argv[0]);
        return 1;
    }
    Json::Value res = getConfigFromFile(argv[2]);
    for (int i = 3; i < argc; ++i) {
        Json::Value v = getConfigFromFile(argv[i]);
        jsonMerge(v, res);
    }

    std::ofstream f(argv[1]);
    Json::StyledWriter writer;
    f << writer.write(res);
    f.close();

    return 0;
}
