import click
import requests
import logging

from library.python.vault_client.instances import Production as VaultClient

logger = logging.getLogger(__name__)


XCODE_VAULT_SECRET = 'sec-01dew31m6ng1h1f2rtbafna8de'
XCODE_CLIENT_ID = 'ee06d0aa5b0b4fbe8ae476bb33d13721'

OAUTH_VAULT_SECRET = 'sec-01f0kwdevxbyg0yf2721c4kpnt'
OAUTH_CLIENT_ID = '0f7488e7bfdf49be85c64158f2b67c6c'


@click.group()
@click.option('--verbose', is_flag=True, default=False)
def cli(verbose):
    """
    Quasar auth helper.

    Allows extraction for various items to pass to IOSDK auth setup.
    All the commands rely on `Sessionid` cookie from yandex.ru domain for the authenticated user.
    """
    if verbose:
        logging.basicConfig(level=logging.DEBUG, format='>>> %(asctime)s %(levelname)-8s %(name)-10s %(message)s')
    else:
        logging.basicConfig(level=logging.INFO, format='>>> %(asctime)s %(levelname)-8s %(name)-10s %(message)s')


@cli.command(short_help='get short xcode for the piluyk')
@click.option('--sessionid', help='Sessionid cookie for the user', required=True)
def xcode(sessionid):
    xcode = get_oauth_code(sessionid, XCODE_VAULT_SECRET, XCODE_CLIENT_ID)

    logging.info(f"xcode is <{xcode}>")


@cli.command(short_help='get short authcode for the piluyk')
@click.option('--sessionid', help='Sessionid cookie for the user', required=True)
def authcode(sessionid):
    authcode = get_oauth_code(sessionid, OAUTH_VAULT_SECRET, OAUTH_CLIENT_ID)

    logging.info(f"authcode is <{authcode}>")


@cli.command(short_help='get the xtoken to get other oauth tokens')
@click.option('--sessionid', help='Sessionid cookie for the user', required=True)
@click.option('--device-id', help='device_id for this token', default='debug_device_id')
@click.option('--device-name', help='device_name for this token', default='debug_device_name')
def xtoken(sessionid, device_id, device_name):
    xcode = get_oauth_code(sessionid, XCODE_VAULT_SECRET, XCODE_CLIENT_ID)

    logging.debug(f"xcode is <{xcode}>")

    logging.debug(f"using device_id <{device_id}> / device_name <{device_name}>")

    xtoken = get_xtoken(xcode, device_id, device_name)

    logging.info(f"xtoken is <{xtoken}>")


@cli.command(short_help='get the oauth token and uid for IOSDK init')
@click.option('--sessionid', help='Sessionid cookie for the user', required=True)
@click.option('--device-id', help='device_id for this token', default='debug_device_id')
@click.option('--device-name', help='device_name for this token', default='debug_device_name')
def auth(sessionid, device_id, device_name):
    xcode = get_oauth_code(sessionid, XCODE_VAULT_SECRET, XCODE_CLIENT_ID)

    logging.debug(f"xcode is <{xcode}>")

    logging.debug(f"using device_id <{device_id}> / device_name <{device_name}>")

    xtoken = get_xtoken(xcode, device_id, device_name)

    logging.debug(f"xtoken is <{xtoken}>")

    oauth_token, uid = get_quasar_auth_info(xtoken, device_id, device_name)

    logging.info(f"Quasar OAuth token is <{oauth_token}> / uid is <{uid}>")


def get_oauth_code(sessionid, secret, client_id):
    vault = VaultClient()
    data = vault.get_version(secret)
    client_secret = data['value']['client_secret']

    # curl -sX POST
    # -H "Ya-Client-Host: yandex.ru"
    # -H 'Ya-Client-Cookie: Session_id=<COOKIE>'
    # 'https://mobileproxy.passport.yandex.net/1/bundle/auth/oauth/code_for_am/'
    # -d 'client_id=ee06d0aa5b0b4fbe8ae476bb33d13721&client_secret=<SECRET>'

    response = requests.post(
        'https://mobileproxy.passport.yandex.net/1/bundle/auth/oauth/code_for_am/',
        headers={
            'Ya-Client-Host': 'yandex.ru',
            'Ya-Client-Cookie': f'Session_id={sessionid}',
        },
        data={
            'client_id': client_id,
            'client_secret': client_secret,
        },
    )

    return response.json()['code']


def get_xtoken(xcode, device_id, device_name):
    vault = VaultClient()
    data = vault.get_version(XCODE_VAULT_SECRET)
    client_secret = data['value']['client_secret']

    response = requests.post(
        'https://oauth.yandex.ru/token',
        data={
            'client_id': XCODE_CLIENT_ID,
            'client_secret': client_secret,
            'grant_type': 'authorization_code',
            'code': xcode,
            'device_id': device_id,
            'device_name': device_name,
        },
    )

    return response.json()['access_token']


def get_quasar_auth_info(xtoken, device_id, device_name) -> (str, str):
    """
    :returns: tuple oauth_token, uid
    """
    vault = VaultClient()
    data = vault.get_version(OAUTH_VAULT_SECRET)
    client_secret = data['value']['client_secret']

    response = requests.post(
        'https://oauth.yandex.ru/token',
        data={
            'client_id': OAUTH_CLIENT_ID,
            'client_secret': client_secret,
            'grant_type': 'x-token',
            'access_token': xtoken,
            'device_id': device_id,
            'device_name': device_name,
        },
    )

    return (response.json()['access_token'], response.json()['uid'])


def main():
    cli()
