from yandex_io.pylibs.kolhoz.kolhoz_api import KolhozDevice
from yandex_io.pylibs.kolhoz.kolhoz_groomer import prepare_for_presmoke

import argparse
import logging
import time
import os

logging.basicConfig()
logger = logging.getLogger()


def get_version(device: KolhozDevice):
    device.shell("/system/vendor/quasar/q version")


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--oauth', type=str, help='OAuthToken')
    parser.add_argument('--get_version', help='Get Version from device', action="store_true")
    parser.add_argument('--release_after', help='Release device in tear down', action="store_true")
    parser.add_argument('--prepare_for_presmoke', help='Prepare for presmoke', action="store_true")
    parser.add_argument('--device_id', help='device_id')
    parser.add_argument("--model", default="yandexmini", help="Speaker model name")

    logger.setLevel(logging.INFO)

    args = parser.parse_args()

    token = args.oauth if args.oauth else os.environ.get("KOLHOZ_TOKEN", None)
    if token is None:
        raise RuntimeError("No kolhoz token provided. Store it in KOLHOZ_TOKEN env or provide with --oauth arg")

    if args.device_id:
        device = KolhozDevice("stub", args.device_id, token)
    else:
        device = KolhozDevice.get_device(token, args.model, "YANDEX_TEAM")
    device.connect()

    time.sleep(5)

    if args.get_version:
        get_version(device)

    if args.prepare_for_presmoke:
        cwd = os.getcwd()
        prepare_for_presmoke(device, cwd)

    if args.release_after:
        device.disconnect()


if __name__ == '__main__':
    main()
