import argparse
import binascii
import os


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--dir', required=True)

    args = parser.parse_args()

    spotter_path = args.dir
    spotter_files = os.listdir(spotter_path)
    spotter_files.sort()
    first = True

    for file in spotter_files:
        buf = open("%s/%s" % (spotter_path, file), 'rb').read()
        if first:
            crc = binascii.crc32(buf)
            first = False
        else:
            crc = binascii.crc32(buf, crc) & 0xFFFFFFFF

    print(crc)
