from yandex_io.pylibs.functional_tests.tus import TUSClient

import argparse
import logging

logging.basicConfig()
logger = logging.getLogger(__name__)


def main():
    logger.setLevel(logging.INFO)

    parser = argparse.ArgumentParser(description='TusClient.')
    parser.add_argument(
        '--login-prefix',
        required=False,
        type=str,
        default='yndx-io-functests-plus-',
        help='prefix for login accounts. default: yndx-io-functests-plus-',
    )
    parser.add_argument('--accounts-num', required=False, type=int, default=1, help='number of accounts to create')
    parser.add_argument(
        '--first-login-suffix-number',
        required=True,
        type=int,
        help='suffix number for first logging to create. I.e. --loggin-prefix=yndx-io-functests-, --login-suffix-number=2, --accounts-num=2. Result accounts: test-2 and test-3',
    )
    parser.add_argument('--with-yandex-plus', action='store_true', default=False, help='Add \'plus\' tag to accounts')
    args = parser.parse_args()

    login_prefix = args.login_prefix
    accounts_num = args.accounts_num
    first_suffix = args.first_login_suffix_number
    with_plus = args.with_yandex_plus

    logger.info(
        f"Create {accounts_num} accounts. Prefix: {login_prefix},"
        f" First suffix: {first_suffix}. Is With Plus: {'yes' if with_plus else 'no'}"
    )

    tus_client = TUSClient()

    tags_str = 'plus' if with_plus else None

    logins = []

    for i in range(first_suffix, first_suffix + accounts_num):
        login = login_prefix + str(i)
        resp = tus_client.createUser(tags=tags_str, login=login)
        logger.info(resp)
        if resp.get('status') == 'ok':
            logins.append((login, resp['account']['uid']))
        else:
            logger.error(f'Failed to create account with login: {login}')

    logger.info(f'Created accounts with logins: {logins}')
