#include <yandex_io/libs/base/persistent_file.h>
#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/protobuf_utils/debug.h>
#include <yandex_io/protos/quasar_proto.pb.h>

using namespace quasar;

void usage(const char* argv0)
{
    std::cerr << "Invalid arguments! \n"
              << "Usage: " << argv0 << " user_config.dat\n";
}

int main(int argc, char** argv)
{
    if (argc < 2) {
        usage(argv[0]);
        return 1;
    }

    const auto filename = argv[1];
    quasar::proto::ConfigStorage result;
    if (!fileExists(filename)) { // Storage is not created yet
        std::cerr << "File not found: " << filename << "\n";
        return 1;
    }

    const std::string serialized = getFileContent(filename);
    if (!result.ParseFromString(TString(serialized))) {
        std::cerr << "Fail to parse file: " << filename << "\n";
        return 1;
    }

    std::cout << convertMessageToDeepJsonString(result) << "\n";

    return 0;
}
