import sys

import os
from gunicorn.app.base import Application

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'yaphone.advisor.project.settings')


def init_localization_cache():
    from yaphone.localization import init_cache
    from django.conf import settings

    init_cache(
        db_name=settings.LOCALIZATION_MONGO_DBNAME,
        mongo_uri=settings.LOCALIZATION_MONGO_URI,
        projects=[settings.LOCALIZATION_PROJECT, settings.LOCALIZATION_TRANSLATIONS_PROJECT,
                  'setup_wizard', 'app_installer', 'recommendation_widget']
    )


def init_mongoengine_connections():
    """
    initialize all connections because we are using gevent workers
    read https://st.yandex-team.ru/ADVISOR-537 for details
    use some valid url as entry point
    """
    from django.core.urlresolvers import resolve

    ENTRY_POINT_URL = '/ping'
    resolve(ENTRY_POINT_URL)


def patch_ylog():
    """"
    monkey-patch ylog thread-local variable for correct work under gevent
    https://st.yandex-team.ru/ADVISOR-1866
    """
    from gevent.local import local
    import ylog

    ylog.context.ContextFormatter.thread_data = local()


class StandaloneApplication(Application):
    def init(self, parser, opts, args):
        pass

    def load(self):
        from django.core.wsgi import get_wsgi_application
        application = get_wsgi_application()

        init_localization_cache()
        init_mongoengine_connections()
        patch_ylog()
        return application


def main():
    app = StandaloneApplication()
    app.run()


def manage():
    from django.core.management import execute_from_command_line
    execute_from_command_line(sys.argv)


if __name__ == "__main__":
    main()
