import os

bind = '[::]:80'
worker_class = 'gevent'
workers = int(os.environ.get('GUNICORN_NUM_WORKERS', 1))
worker_connections = int(os.environ.get('GUNICORN_WORKER_CONNECTIONS', 25))
backlog = int(os.getenv('GUNICORN_BACKLOG', workers * worker_connections))
timeout = 60

# Docker will wait only 10 seconds before hard shutdown
graceful_timeout = 5

pidfile = '/var/run/gunicorn.pid'

logger_class = 'yaphone.advisor.common.loggers.GunicornLogger'
access_log_format = '%(t)s %({Host}i)s %({x-forwarded-for-y}i)s "%(r)s" %(s)s "%(f)s" "%(a)s" "%(l)s" %(L)s %(l)s ' \
                    '%(b)s "%(L)s" 0 %(unixtime_msec)s "%({x-yareqfinish}o)s" "%({x-yauuid}i)s" ' \
                    '"%({x-yarequestid}o)s" "-;-;-;-"'
logconfig = '/etc/gunicorn/logging.conf'

limit_request_line = 8190
