import logging
from datetime import datetime

from yaphone.advisor.common.localization_helpers import get_config_value
from yaphone.advisor.launcher.models import db

logger = logging.getLogger(__name__)


def _need_to_delay(device_info_created_ts, delay_period):
    return (datetime.utcnow().replace(tzinfo=None) -
            device_info_created_ts.replace(tzinfo=None)).total_seconds() < delay_period


def get_config(client):
    config_name = get_config_value(client, 'config_name', default_value='def')

    doc = get_config_by_name(config_name)
    result = {
        'config_name': doc['config_name'],
        'places': [],
    }

    for place in doc['places']:
        backend_params = place.pop('backend_params', {})
        if _need_to_delay(client.created_at, backend_params.get('delay_period', 0)):
            place['type'] = 'empty'

        result['places'].append(place)

    return result


def get_config_by_name(config_name):
    return db.launcher_conf.find_one({'config_name': config_name}, {'_id': False})


def places_hierarchy(place):
    while place:
        yield place
        place = place.rpartition('/')[0]


def get_param_by_place(place, param, config):
    # TODO: bad config structure
    logger.debug('config=%s', str(config))
    for config_place in config['places']:
        if config_place['place'] == place:
            return config_place.get(param)

    return None


class UnknownConfigParameter(Exception):
    pass
