from collections import OrderedDict

import mongoengine as me
from datetime import datetime

from yaphone.advisor.launcher.models.wallpapers import S3Image


class Icons(me.Document):
    DPI = OrderedDict((
        ('mdpi', 48),
        ('hdpi', 72),
        ('xhdpi', 96),
        ('xxhdpi', 144),
        ('xxxhdpi', 192),
    ))
    PACKS = ('pillow', 'circle')
    DEFAULT_PACK = 'pillow'

    package_name = me.StringField(required=True)
    activity = me.StringField(required=False, null=True)
    language = me.StringField(required=False, null=True, regex=r'^[a-z]{2}$')
    pack = me.StringField(required=True, choices=PACKS)
    clid1 = me.ListField(me.StringField(regex=r'^\d+$'), required=False, null=True)
    priority = me.IntField(required=True)
    mdpi = me.EmbeddedDocumentField(S3Image, required=True)
    hdpi = me.EmbeddedDocumentField(S3Image, required=True)
    xhdpi = me.EmbeddedDocumentField(S3Image, required=True)
    xxhdpi = me.EmbeddedDocumentField(S3Image, required=True)
    xxxhdpi = me.EmbeddedDocumentField(S3Image, required=True)

    updated_at = me.DateTimeField(required=False, default=datetime.utcnow)

    meta = {
        'strict': False,
        'indexes': ['package_name'],
    }
