from mongoengine import Document, EmbeddedDocument
from mongoengine.fields import EmbeddedDocumentField, ListField, IntField, StringField, DictField, BooleanField

from yaphone.advisor.launcher.models.wallpapers import S3Image


class Button(EmbeddedDocument):
    id = StringField(required=True)
    caption = StringField(required=True)
    action = StringField(required=False)
    style = StringField(required=False)

    meta = {
        'strict': False
    }


class SettingsPromoBlock(Document):
    id = StringField(required=True, primary_key=True)
    experiment = ListField(StringField(), required=True)
    badge = BooleanField(required=False, default=False)
    title = StringField(required=True)
    priority = IntField(required=True)
    description = StringField(required=True)
    buttons = ListField(EmbeddedDocumentField(Button))
    image = EmbeddedDocumentField(S3Image, required=False)
    show_conditions = DictField(required=False)

    meta = {
        'ordering': ['-priority'],
        'strict': False,
    }
