from datetime import datetime
from mongoengine import (
    Document, EmbeddedDocument,
    StringField, EmbeddedDocumentField,
    DateTimeField, ListField, URLField,
)

from yaphone.advisor.launcher.models.wallpapers import S3Image

TEXT_LENGTH = 120
VERSION_LENGTH = 30


class Apk(EmbeddedDocument):
    url = StringField(required=False)
    hash = StringField(max_length=40, required=False)

    meta = {
        'strict': False
    }


class Theme(Document):
    DEVICE_TYPES = ('phone', 'tablet')

    title = StringField(max_length=TEXT_LENGTH, required=True)
    theme_id = StringField(max_length=TEXT_LENGTH, required=True)
    device_type = ListField(StringField(choices=DEVICE_TYPES), required=False)
    screens = ListField(EmbeddedDocumentField(S3Image), required=False)
    updated_at = DateTimeField(default=datetime.utcnow, required=False)

    meta = {
        'strict': False,
        'allow_inheritance': True
    }


class SimpleTheme(Theme):
    pass


class ApkTheme(Theme):
    tracking_url = URLField(required=False)
    min_version = StringField(max_length=VERSION_LENGTH, required=False)
    apk = EmbeddedDocumentField(Apk, required=False)
    preview_image = EmbeddedDocumentField(S3Image, required=False)
    preview_text_color = StringField(required=False)
    preview_background_color = StringField(required=False)
