# -*- coding: utf-8 -*-

from functools import partial

import django.conf.urls

from yaphone.advisor.launcher.views.app_icons import IconsForAppsView, IconsForAppsViewV2
from yaphone.advisor.launcher.views.apps import SearchAppsView
from yaphone.advisor.launcher.views.browser_icons import IconsForUrlsView, IconsForUrlsViewV2
from yaphone.advisor.launcher.views.categories import CategoriesForAppsView, CategoriesForAppsViewV2
from yaphone.advisor.launcher.views.config import ConfigView, ExperimentsView, ExperimentsViewV2, AllExperimentsView
from yaphone.advisor.launcher.views.location import GetLocationView
from yaphone.advisor.launcher.views.minus_one import ContentBlocksView
from yaphone.advisor.launcher.views.settings_promo import SettingsPromoView
from yaphone.advisor.launcher.views.support import BugReportView, BugReportViewV2
from yaphone.advisor.launcher.views.themes import ThemesView, ThemesViewV2
from yaphone.advisor.launcher.views.wallpapers import (WallpapersView, WallpapersViewV2,
                                                       WallpapersViewV3, GetWallpaperView,
                                                       WallpapersAutochangeView, WallpapersActionView,
                                                       WallpapersFeedView)

url = partial(django.conf.urls.url, kwargs={'application': 'launcher'})

urlpatterns = [
    url(r'^v[12]/search_apps/?$', SearchAppsView.as_view()),

    url(r'^v1/config/?$', ConfigView.as_view()),
    url(r'^v1/categories_for_apps/?$', CategoriesForAppsView.as_view()),
    url(r'^v1/icons_for_apps/?$', IconsForAppsView.as_view()),
    url(r'^v1/experiments/?$', ExperimentsView.as_view()),
    url(r'^v1/wallpapers/?$', WallpapersView.as_view()),
    url(r'^v1/themes/?$', ThemesView.as_view()),
    url(r'^v1/bugreport/?$', BugReportView.as_view()),
    url(r'^v1/icons_for_urls/?$', IconsForUrlsView.as_view()),
    url(r'^v1/content_blocks/?$', ContentBlocksView.as_view()),

    url(r'^v2/experiments/?$', ExperimentsViewV2.as_view()),
    url(r'^v2/icons_for_apps/?$', IconsForAppsViewV2.as_view()),
    url(r'^v2/categories_for_apps/?$', CategoriesForAppsViewV2.as_view()),
    url(r'^v2/wallpapers/?$', WallpapersViewV2.as_view()),
    url(r'^v2/themes/?$', ThemesViewV2.as_view()),
    url(r'^v2/bugreport/?$', BugReportViewV2.as_view()),
    url(r'^v2/icons_for_urls/?$', IconsForUrlsViewV2.as_view()),
    url(r'^v2/all_experiments/(?P<project_name>\w+)/?$', AllExperimentsView.as_view()),
    url(r'^v2/location/?$', GetLocationView.as_view()),
    url(r'^v2/get_wallpaper/?$', GetWallpaperView.as_view()),
    url(r'^v2/settings_promo_block/?$', SettingsPromoView.as_view()),

    url(r'^v3/wallpapers/action/?$', WallpapersActionView.as_view()),
    url(r'^v3/wallpapers/autochange/?$', WallpapersAutochangeView.as_view()),
    url(r'^v3/wallpapers/feed/?$', WallpapersFeedView.as_view()),
    url(r'^v3/wallpapers/?$', WallpapersViewV3.as_view()),
]
