from urllib import quote_plus

import logging
from django.conf import settings
from django.core.cache import cache
from django.http.response import HttpResponse, HttpResponseRedirect, HttpResponseServerError
from redis_cache.backends.base import BaseRedisCache

from yaphone.advisor.advisor.models import is_ready as mongo_is_ready
from yaphone.advisor.common.resizer import make_scaled_image_url
from yaphone.advisor.common.screen_properties import dp_to_px

logger = logging.getLogger()

ALL_TO_JPEG_TYPEMAP = quote_plus('*:jpeg;')


def redis_cache_is_ready():
    if not isinstance(cache, BaseRedisCache):
        # Cache is not redis
        return True
    return all(redis.ping() for redis in cache.client_list)


def get_image(request, **kwargs):
    args = request.GET
    url = args['url']
    if not url.startswith(settings.MDS_AVATAR_HOST):
        return HttpResponse(status=404)
    dpi = float(args['dpi'])
    w_dpi, h_dpi = int(args['w_dpi']), int(args['h_dpi'])
    w_pix, h_pix = int(args['w_pix']), int(args['h_pix'])
    w = dp_to_px(w_dpi, dpi) or w_pix
    h = dp_to_px(h_dpi, dpi) or h_pix
    new_url = make_scaled_image_url(url=url, width=w, height=h, quality=85, typemap=ALL_TO_JPEG_TYPEMAP,
                                    host=request.get_host(), path_prefix='/resizer')
    return HttpResponseRedirect(redirect_to=new_url)


# noinspection PyUnusedLocal
def ping(request):
    if not mongo_is_ready():
        return HttpResponseServerError('mongo is not ready')
    if not redis_cache_is_ready():
        return HttpResponseServerError('redis cache is not ready')
    return HttpResponse('Ok')
