from rest_framework.response import Response
from rest_framework.serializers import Serializer
from yaphone.advisor.advisor.app_info_loader import app_info_loader

from yaphone.advisor.advisor.models.categories import ya_category_cache
from yaphone.advisor.advisor.serializers.base import CommaSeparatedListField
from yaphone.advisor.advisor.views.base import MobileApiView, StatelessView


def get_yandex_categories(categories):
    if categories:
        yandex_categories = set()
        # noinspection PyTypeChecker
        for category in categories:
            yandex_category = ya_category_cache.get_by_google_name(category)
            if yandex_category:
                yandex_categories.update(yandex_category)
        return list(yandex_categories)


def get_categories_for_apps_response(package_names, language):
    result = {}
    apps_info = app_info_loader.get_apps_info(package_names, language, raise_on_missing=False)
    for package_name, app_info in apps_info.iteritems():
        yandex_categories = get_yandex_categories(app_info['categories'])
        if yandex_categories:
            result[package_name] = {"categories": [
                {"name": category.name, "title": category.get_title(language=language)}
                for category in yandex_categories
            ]}
    return Response(result)


class CategoriesForAppsQueryValidator(Serializer):
    package_names = CommaSeparatedListField(max_count=20, required=True)


class CategoriesForAppsView(MobileApiView):
    validator_class = CategoriesForAppsQueryValidator

    # noinspection PyUnusedLocal
    def get(self, request, *args, **kwargs):
        validated_data = self.get_validated_data(request.query_params)
        package_names = validated_data['package_names']
        language = self.client.profile.locale.language
        return get_categories_for_apps_response(package_names, language)


class CategoriesForAppsViewV2(StatelessView):
    validator_class = CategoriesForAppsQueryValidator

    # noinspection PyUnusedLocal
    def get(self, request, *args, **kwargs):
        validated_data = self.get_validated_data(request.query_params)
        package_names = validated_data['package_names']
        language = self.client.language
        return get_categories_for_apps_response(package_names, language)
