from rest_framework.response import Response
from yaphone.advisor.common import localization_keys

from yaphone.advisor.advisor.views.base import StatelessView
from yaphone.advisor.common.localization_helpers import get_config_value
from yaphone.advisor.launcher.models.settings_promo import SettingsPromoBlock
from yaphone.advisor.launcher.serializers import SettingsPromoBlockListSerializer
from yaphone.advisor.launcher.validators import SettingsPromoBlockQueryValidator


class SettingsPromoView(StatelessView):
    validator_class = SettingsPromoBlockQueryValidator

    def get(self, request, *args, **kwargs):
        experiment = get_config_value(
            client=self.client,
            key=localization_keys.PROMO_SETTINGS_EXPERIMENT
        )
        blocks = SettingsPromoBlock.objects(experiment=experiment)
        session_skips_after_hide = int(get_config_value(
            client=self.client,
            key=localization_keys.SESSION_SKIPS_AFTER_HIDE,
            default_value=0,
            log_missing=True,
        ))
        data = self.get_validated_data(request.query_params)
        context = {
            'client': self.client,
            'host': self.host,
            'height': data['image_height'],
            'width': data['image_width']
        }
        serializer = SettingsPromoBlockListSerializer(blocks, context=context)
        return Response({'session_skips_after_hide': session_skips_after_hide, 'blocks': serializer.data})
