from rest_framework.exceptions import NotFound
from rest_framework.response import Response

from yaphone.advisor.advisor.views.base import MobileApiView, StatelessView


def get_bugreport_response(lbs_info):
    return Response({
        'location': str(lbs_info.location),
        'tz_name': lbs_info.time_zone.name if lbs_info.time_zone else None,
        'utc_offset': str(lbs_info.time_zone.utc_offset) if lbs_info.time_zone else None,
        'country': lbs_info.country,
        'country_init': lbs_info.country_init,
        'fix_country_init': lbs_info.fix_country_init,
        'updated_at': str(lbs_info.updated_at)
    })


class BugReportView(MobileApiView):
    # noinspection PyUnusedLocal
    def get(self, request, *args, **kwargs):
        return get_bugreport_response(lbs_info=self.client.profile.lbs_info)


class BugReportViewV2(StatelessView):
    # noinspection PyUnusedLocal
    def get(self, request, *args, **kwargs):
        if not self.profile_exists:
            raise NotFound('User profile not found')
        return get_bugreport_response(lbs_info=self.client.profile.lbs_info)
