from rest_framework.response import Response

from yaphone.advisor.advisor.views.base import StatelessView
from yaphone.advisor.common.tools import make_s3_mds_url
from yaphone.advisor.launcher.models import db

KIND_MUSIC_WALLPAPER = 'music-wallpaper'


class MusicWallpapersView(StatelessView):
    # noinspection PyUnusedLocal
    def get(self, request):
        result = []
        for record in db.music_wallpapers.find():
            image = record['image']
            url = make_s3_mds_url(image['key'], self.host)
            result.append({
                'url': url,
                'md5': image['hash']
            })
        return Response(result)
