# -*- coding: utf-8 -*-
import logging
import os

import yenv
from tvmauth import BlackboxTvmId as BlackboxClientId
from tvm2.protocol import BLACKBOX_MAP
from yt import logger as yt_logger

from yaphone.advisor.common.raven_helpers import raven_tune
from yaphone.advisor.common.template import InvalidTemplateString
from yaphone.advisor.project.version import VERSION

# Localization
LOCALIZATION_PROJECT = 'launcher'
LOCALIZATION_TRANSLATIONS_PROJECT = 'launcher_translations'

# Basic Django
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '&s1u_!+py!x&e(dz$$z)funh(%1-x1mr=^l9+$4nr97zh_u#6e'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = yenv.choose_key_by_type({
    'production': False,
    'development': True,
}, fallback=True)

if not DEBUG and os.environ.get('JETBRAINS_REMOTE_RUN') == '1':
    DEBUG = True  # Always enable debug when run in PyCharm remote interpreter

ALLOWED_HOSTS = ['*']

# Application definition

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django_hosts',
    'cache_memoize',
    'rest_framework',

    # project apps
    'yaphone.advisor.common',
    'yaphone.advisor.launcher',
    'yaphone.advisor.advisor',
    'yaphone.advisor.setup_wizard',
    'yaphone.advisor.lockscreen',
    'yaphone.advisor.demo',
)

# Uncaught exceptions reporting
if not DEBUG:
    INSTALLED_APPS += (
        'raven.contrib.django.raven_compat',
    )

MIDDLEWARE = (
    'yaphone.advisor.common.middleware.FixEmptyHostMiddleWare',
    'yaphone.advisor.common.middleware.LoggingContextMiddleware',
    'django_hosts.middleware.HostsRequestMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.middleware.gzip.GZipMiddleware',
    'django.middleware.http.ConditionalGetMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django_hosts.middleware.HostsResponseMiddleware',
)

if yenv.type != 'production':
    MIDDLEWARE += ('yaphone.advisor.common.middleware.DegradationMiddleware',)

ROOT_URLCONF = 'yaphone.advisor.project.urls'

ROOT_HOSTCONF = 'yaphone.advisor.project.hosts'

DEFAULT_HOST = 'launcher'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'string_if_invalid': InvalidTemplateString(),
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
            ],
        },
    },
]

WSGI_APPLICATION = 'yaphone.advisor.bin.app.application'

# Database
# https://docs.djangoproject.com/en/1.8/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': ':memory:',
    }
}

# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/

LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'Europe/Moscow'
USE_I18N = False
USE_L10N = False
USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

STATIC_URL = '/static/'

REST_FRAMEWORK = {
    'DEFAULT_RENDERER_CLASSES': (
        'yaphone.advisor.common.rest.UJSONRenderer',
    ),
    'DEFAULT_PARSER_CLASSES': (
        'rest_framework.parsers.JSONParser',
    ),
    'DEFAULT_THROTTLE_RATES': {
        'weather': '5/min',
    },
    'EXCEPTION_HANDLER': 'yaphone.advisor.advisor.views.base.custom_exception_handler'
}

if not DEBUG:
    REST_FRAMEWORK['DEFAULT_THROTTLE_CLASSES'] = (
        'yaphone.advisor.common.throttling.ScopedRateUUIDThrottle',
    )

SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTO', 'https')

CORS_ORIGIN_REGEX_WHITELIST = ('^(https?://)?([\w_-]+\.)*yandex\.(ru|com|com\.tr|ua|kz|by)$',)

# Database settings
MONGO_TIMEOUT_PARAMS = {
    'maxPoolSize': 4,
    'serverSelectionTimeoutMS': 5000,
    'connectTimeoutMS': 2000
}

mongodb_uri_template = 'mongodb://{user}:{password}@{hosts}/{database}?maxPoolSize=4'

MONGO_HOSTS = yenv.choose_key_by_type({
    'production': [
        'vla-8h8moxom5mcqvhxq.db.yandex.net:27018',
        'sas-350atkewrtqdqznw.db.yandex.net:27018',
        'iva-g4rokm43mg6rjizc.db.yandex.net:27018',
    ],
    'testing': [
        'sas-m6ed1vwh01lxm0td.db.yandex.net:27018',
        'vla-5xqt1wmnesk3vqto.db.yandex.net:27018',
    ],
}, fallback=True)

MONGO_USER = os.environ.get('MONGO_USER')
MONGO_PASSWORD = os.environ.get('MONGO_PASSWORD')

MONGO_DB_NAME = 'advisor_db'

MONGO_URI = mongodb_uri_template.format(
    user=MONGO_USER,
    password=MONGO_PASSWORD,
    hosts=','.join(MONGO_HOSTS),
    database=MONGO_DB_NAME,
)

LOCALIZATION_MONGO_DBNAME = 'localizations_db'

LOCALIZATION_MONGO_URI = mongodb_uri_template.format(
    user=MONGO_USER,
    password=MONGO_PASSWORD,
    hosts=','.join(MONGO_HOSTS),
    database=LOCALIZATION_MONGO_DBNAME,
)

SHARED_REDIS_DB = yenv.choose_key_by_type({
    'production': 6,
    'stress': 5,
    'testing': 4,
    'development': 1,
}, fallback=True)

SHARED_REDIS_PORT = yenv.choose_key_by_type({
    'production': 6301,
    'development': 6379,
}, fallback=True)

REDIS_URL_SHARED = yenv.choose_key_by_type({
    'production': 'redis://:{auth}@localhost:{port}/{db}'.format(  # HAProxy redis
        auth=os.environ.get('SHARED_REDIS_AUTH', ''),
        db=SHARED_REDIS_DB,
        port=SHARED_REDIS_PORT
    ),
    'development': 'redis://localhost:6379/1',  # local redis on default port
}, fallback=True)

CACHES = {
    'default': {
        'BACKEND': 'redis_cache.RedisCache',
        'LOCATION': 'redis://localhost:6379/1',
        'TIMEOUT': 86400,  # 1 day
        'VERSION': VERSION,
        'OPTIONS': {
            'SERIALIZER_CLASS': 'yaphone.advisor.common.cache.UJSONSerializer',
        }
    },
    'shared': {
        'BACKEND': 'redis_cache.RedisCache',
        'LOCATION': REDIS_URL_SHARED,
        'TIMEOUT': 86400,  # 1 day
        'VERSION': VERSION,
        'OPTIONS': {
            'SERIALIZER_CLASS': 'yaphone.advisor.common.cache.UJSONSerializer',
        }
    },
}

SENTRY_URL_TEST = 'https://c3b2751272f94e289b41900c1763a0b3' \
                  '@sentry-test-proxy.t.yandex.net/505?verify_ssl=0&timeout=5'
SENTRY_URL_PROD = 'https://84c0a0fbfcf14693bde22bdb06248510' \
                  '@sentry.iddqd.yandex.net/845?verify_ssl=0&timeout=5'

os.environ.setdefault('SENTRY_DSN', yenv.choose_key_by_type({
    'testing': SENTRY_URL_TEST,
    'production': SENTRY_URL_PROD,
    'stress': '',
    'development': '',
}, fallback=True))
SENTRY_DSN = os.getenv('SENTRY_DSN')

RAVEN_CONFIG = {
    'dsn': SENTRY_DSN,
    'string_max_length': 8192,
    'list_max_length': 256,
    'release': VERSION,
    'environment': yenv.type,
}

raven_tune(max_breadcrumbs=20)

ADDITIONAL_LOGGING_HEADERS = {
    'uuid': 'X_YAUUID',
    'accept_language': 'Accept-Language',
    'clid1': 'X-YaClid1', 'clid1006': 'X-YaClid1006',
}

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            'format': '[%(asctime)s] [%(process)d] [%(levelname)s] [%(name)s] %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'class': 'logging.Formatter',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter'
        }
    },
    'handlers': {
        'qloud': {
            'class': 'logging.StreamHandler',
            'formatter': 'json'
        },
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'default',
        },
        'sentry': {
            'level': 'ERROR',
            'class': 'raven.contrib.django.raven_compat.handlers.SentryHandler',
        },
    },
    'loggers': {
        '': {
            'level': yenv.choose_key_by_type({
                'production': 'INFO',
                'development': 'DEBUG'
            }, fallback=True),
            'handlers': yenv.choose_key_by_type({
                'production': ['qloud', 'sentry'],
                'stress': ['qloud'],
                'development': ['console'],
            }, fallback=True),
            'propagate': True,
        },
    },
}

# Replace custom YT logger by rootLogger
yt_logger.LOGGER = logging.getLogger()

# Redirect Python Warnings from stderr to logging system
logging.captureWarnings(capture=True)

# Yandex services
# MDS

MDS_HOST = yenv.choose_key_by_type({
    'production': 'https://storage.mds.yandex.net',
    'testing': 'https://storage.mdst.yandex.net',
}, fallback=True)

MDS_WRITE_HOST = yenv.choose_key_by_type({
    'production': 'http://storage-int.mds.yandex.net:1111',
    'testing': 'http://storage-int.mdst.yandex.net:1111',
}, fallback=True)

MDS_NAMESPACE = 'lnchr'

MDS_ACCESS_TOKEN = os.environ.get('MDS_ACCESS_TOKEN')

MDS_URL_TEMPLATE = '{mds_host}/get-{mds_namespace}/%s'.format(mds_host=MDS_HOST, mds_namespace=MDS_NAMESPACE)

MDS_AVATAR_HOST = 'http://avatars.mds.yandex.net'

# Portal

PORTAL_NEWS_URL = 'https://yandex.ru/portal/api/launcher/0'
CONTENT_BLOCK_HEADER_TEMPLATE_KEY = 'minus_one_screen_header'
DEFAULT_WEATHER_TTV = 1000
DEFAULT_WEATHER_TTL = 1000

# S3

S3_MDS_URL_TEMPLATE = yenv.choose_key_by_type({
    'production': 'https://lnchr-files.s3.yandex.net/%s',
    'testing': 'https://lnchr-files.s3.mdst.yandex.net/%s',
}, fallback=True)

# Resizer

RESIZER_SECRET_KEY = os.environ.get('RESIZER_SECRET_KEY', '')

RESIZER_HOST = yenv.choose_key_by_type({
    'production': 'https://resize.yandex.net',
    'testing': 'https://resize.rs.yandex.net',
    'stress': 'https://resize.load.yandex.net',
}, fallback=True)

# YT

YT_SIMILAR_APPS = '//home/extdata/mobile/google_play/latest/appdb_similar_apps'
YT_TOKEN = os.environ.get('YT_TOKEN')
YT_PROXIES = os.environ.get('YT_PROXIES', 'hahn.yt.yandex.net,arnold.yt.yandex.net').split(',')
YT_APPS_DYNAMIC_TABLE = '//home/advisor/apps/dynamic'

# Jafar
JAFAR_URL = yenv.choose_key_by_type({
    # 'development': 'http://jafar.{user}.dev.yandex.net:5001'.format(user=os.environ.get('USER')),
    'testing': 'https://jafar.tst.phone.yandex.net',
    'stress': 'https://jafar.regression.phone.yandex.net',
    'production': 'https://jafar.phone.yandex.net',
}, fallback=True)

# LBS
LBS_URL = 'https://api-int.lbs.yandex.net/geolocation'
LBS_TOKEN = os.environ.get('LBS_TOKEN')

# Crypta and Big Brother
BIGB_URL = 'http://bigb-fast.yandex.ru/bigb'
BIGB_CLIENT_ID = '2001337'

# http Geobase
GEOBASE_URL = 'http://geobase.qloud.yandex.ru'

# classic Geobase
GEODATA_BIN_PATH = '/var/cache/geobase/geodata6.bin'

# Tanker
TANKER_URL = 'https://tanker-api.yandex-team.ru/'
TANKER_OAUTH_TOKEN = os.environ.get('TANKER_OAUTH_TOKEN')
TANKER_PROJECT_NAME = 'launcher'

# Weather
WEATHER = {
    'api_key': os.environ.get('WEATHER_API_KEY'),
    'api_url': 'http://api.weather.yandex.ru/v1/forecast',
}

# Setup Wizard

DOWNLOAD_FROM_BETA_URL_TEMPLATE = yenv.choose_key_by_type({
    'production': 'https://updater.mobile.yandex.net/api/v1/download/?package_name={package_name}',
    'testing': 'https://updater.tst.mobile.yandex.net/api/v1/download/?package_name={package_name}',
}, fallback=True)

BILLING_API_URL = yenv.choose_key_by_type(
    {
        'testing': 'https://trust-paysys-test.paysys.yandex.net:8025/bindings-external/v2.0/bindings/',
        'production': 'https://trust-paysys.paysys.yandex.net:8025/bindings-external/v2.0/bindings/'
    },
    fallback=True
)

BILLING_GET_CARD_INFO_TOKEN = os.environ.get('BILLING_GET_CARD_INFO_TOKEN')

# TVM2

TVM_CLIENT_ID = yenv.choose_key_by_type({
    'production': '2001582',
    'testing': '2001670',
    'development': '2001672',
}, fallback=True)
TVM_CLIENT_SECRET = os.environ.get('TVM_CLIENT_SECRET')

BLACKBOX_CLIENT = yenv.choose_key_by_type({
    'production': BlackboxClientId.Prod,
    'testing': BlackboxClientId.Mimino,
}, fallback=True)
BLACKBOX_CLIENT_ID = BLACKBOX_CLIENT.value

BLACKBOX_URL = BLACKBOX_MAP[BLACKBOX_CLIENT]['url']

CACHES_LIFETIME = {
    'categories': 60 * 60 * 12,
    'jafar_card_configs': 10 * 60,
}

os.environ.setdefault("REQUESTS_CA_BUNDLE", '/etc/ssl/certs/ca-certificates.crt')

# used for wallpapers update
BACKEND_HOST = yenv.choose_key_by_type({
    'production': 'launcher.mobile.yandex.net',
    'testing': 'launcher.tst.mobile.yandex.net',
    'stress': 'launcher01h.cloud.load.mobile.yandex.net',
}, fallback=True)

AUTOCHANGE_RESPONSE_SIZE = 10
AUTOCHANGE_BLACKLIST_SIZE = 103

GIFT_PACKAGE_NAME_PREFIX = 'gift:'

USE_HTTP_GEOBASE = bool(os.environ.get('USE_HTTP_GEOBASE'))

SUP_LOGIN_URL = 'https://sup.yandex.net/v2/login'
SUP_LOGOUT_URL = 'https://sup.yandex.net/v2/logout'
