"""advisor URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.8/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Add an import:  from blog import urls as blog_urls
    2. Add a URL to urlpatterns:  url(r'^blog/', include(blog_urls))
"""
from django.conf import settings
from django.conf.urls import include, url

# noinspection PyUnresolvedReferences
import yaphone.advisor.advisor.urls
import yaphone.advisor.launcher.urls
from yaphone.advisor.launcher.views.base import ping, get_image
from yaphone.advisor.weather.views import WeatherForecastView, WeatherForecastViewV2

urlpatterns = [
    url(r'^api/', include(yaphone.advisor.launcher.urls)),
    url(r'^api/', include(yaphone.advisor.advisor.urls), kwargs={'application': 'launcher'}),
    url(r'^api/v1/weather_forecast/?$', WeatherForecastView.as_view()),
    url(r'^api/v2/weather_forecast/?$', WeatherForecastViewV2.as_view()),
    url(r'^ping/?$', ping),
    url(r'^get_image/?$', get_image),
]

if settings.DEBUG:
    from django.views.generic import RedirectView

    re_mds_get_namespace = r'^get-{namespace}/(?P<tail>.*)$'.format(namespace=settings.MDS_NAMESPACE)
    re_mds_s3_get_namespace = r'^get-lnchr-s3/(?P<tail>.*)$'

    urlpatterns += [
        url(r'^resizer/?$',
            RedirectView.as_view(url=settings.RESIZER_HOST, query_string=True)),
        url(re_mds_get_namespace,
            RedirectView.as_view(url=settings.MDS_URL_TEMPLATE % '%(tail)s')),
        url(re_mds_s3_get_namespace,
            RedirectView.as_view(url=settings.S3_MDS_URL_TEMPLATE % '%(tail)s')),
        url(r'^get-google-play-app-icon/(?P<tail>.*)$',
            RedirectView.as_view(url=settings.MDS_AVATAR_HOST + '/get-google-play-app-icon/%(tail)s')),
    ]
