from rest_framework.serializers import Serializer, CharField, UUIDField, IntegerField


# noinspection PyAbstractClass
class BasePhoneQueryValidator(Serializer):
    phone_id = CharField(required=True, min_length=8)
    device_id = UUIDField(required=True)


# noinspection PyAbstractClass
class GiftsPreviewQueryValidator(BasePhoneQueryValidator):
    device_id = UUIDField(required=False)


# noinspection PyAbstractClass
class GiftUsedQueryValidator(BasePhoneQueryValidator):
    phone_id = CharField(required=False)
    device_id = UUIDField(required=False)
    package_name = CharField(required=True)
    key = CharField(required=True)
    value = CharField(required=True)
    uid = IntegerField(required=False)


# noinspection PyAbstractClass
class GiftsTransferQueryValidator(BasePhoneQueryValidator):
    phone_id = CharField(required=False)
    login = CharField(required=False)
