from functools import partial

import django.conf.urls

from yaphone.advisor.advisor.models.client import UserAgent
from yaphone.advisor.advisor.user_agent_creator import user_agent_creator
from yaphone.advisor.advisor.views.device import AndroidClientInfoView, LbsInfoView
from yaphone.advisor.launcher.views.config import ExperimentsViewV2
from yaphone.advisor.setup_wizard.views.gifts import (GiftsPreviewView, GiveGiftsView, GiftUsedView,
                                                      ActivationView, GiftsTransferView)

user_agent_creator.set_fallback(UserAgent.from_string)

app_installer_url = partial(django.conf.urls.url, kwargs={'application': 'app_installer'})
setup_wizard_url = partial(django.conf.urls.url, kwargs={'application': 'setup_wizard'})

urlpatterns = [
    app_installer_url(r'^api/v1/android_client_info/?$', AndroidClientInfoView.as_view()),
    app_installer_url(r'^api/v1/lbs_info/?$', LbsInfoView.as_view()),

    setup_wizard_url(r'^api/v1/experiments/?$', ExperimentsViewV2.as_view()),
    setup_wizard_url(r'^api/v1/gifts_preview/?$', GiftsPreviewView.as_view()),
    setup_wizard_url(r'^api/v1/activation/?$', ActivationView.as_view()),
    setup_wizard_url(r'^api/v1/give_gifts/?$', GiveGiftsView.as_view()),
    setup_wizard_url(r'^api/v1/gift_used/?$', GiftUsedView.as_view()),
    setup_wizard_url(r'^api/v1/gifts_transfer/?$', GiftsTransferView.as_view()),
]
