from __future__ import print_function

import json
import sys

import requests
from PIL import Image

from rec_colors_np import calculate


def process_image(obj):
    with Image.open(obj) as image:
        if image.mode not in ('RGB', 'RGBA'):
            image = image.convert('RGBA')
        return calculate(image)


def process_url(url):
    r = requests.get(url, stream=True)
    return process_image(r.raw)


if __name__ == '__main__':
    filename = sys.argv[1]
    with Image.open(filename) as image:
        if image.mode not in ('RGB', 'RGBA'):
            image = image.convert('RGBA')
        info = calculate(image)
        print(json.dumps(info, indent=2))
