__all__ = ['UniformColorDetector']


def find_max(data):
    j_found = 0
    c = len(data)
    # noinspection PyCompatibility
    for j in xrange(1, c):
        if data[j] > data[j_found]:
            j_found = j
    return j_found


def get_sum_near(data, index, delta):
    c = len(data)
    sum_c = 0
    # noinspection PyCompatibility
    for j in xrange(index - delta, index + delta + 1):
        if 0 <= j < c:
            sum_c += data[j]
    return sum_c


class UniformColorDetector(object):
    def __init__(self):
        self.r = [0] * 256
        self.g = [0] * 256
        self.b = [0] * 256
        self.count = 0

    def register(self, color):
        self.count += 1
        self.r[color[0]] += 1
        self.g[color[1]] += 1
        self.b[color[2]] += 1

    def has_uniform_color(self, level):
        threshold = int(self.count * level)
        # Determine if all the pixels has roughly the same color
        rs = get_sum_near(self.r, find_max(self.r), 2)
        gs = get_sum_near(self.g, find_max(self.g), 2)
        bs = get_sum_near(self.b, find_max(self.b), 2)
        return rs >= threshold and gs >= threshold and bs >= threshold
