import datetime
import logging

import click

from advisor_money.settings import ISO_DATE_FORMAT, ZOOKEEPER_HOST
from advisor_money.utils.yt_utils import make_lock_name


class DateType(click.ParamType):
    name = 'date'

    def convert(self, value, param, ctx):
        if value is None:
            return value

        if isinstance(value, datetime.date):
            return value

        try:
            date_value = datetime.datetime.strptime(value, ISO_DATE_FORMAT).date()
            return date_value
        except ValueError as e:
            self.fail('Could not parse date string "{date_str}" formatted as {format} ({error})'.format(
                date_str=value, format=ISO_DATE_FORMAT, error=e, ), param, ctx)
